<?php 
session_start();
include('koneksi.php');

if(isset($_POST["hapus_laptop"])){
    // Periksa apakah user adalah admin
    if (isset($_SESSION['loggedin']) && $_SESSION['role'] === 'admin') {
        $id_hapus_laptop = $_POST['id_hapus_laptop'];
        $stmt_delete = mysqli_prepare($selectdb, "DELETE FROM `data_laptop` WHERE `id_laptop` = ?");
        mysqli_stmt_bind_param($stmt_delete, "i", $id_hapus_laptop);
        mysqli_stmt_execute($stmt_delete);
        mysqli_stmt_close($stmt_delete);
        // Reset AUTO_INCREMENT (opsional, tapi bisa membantu menjaga ID tetap rapi)
        // HANYA LAKUKAN INI DI LINGKUNGAN PENGEMBANGAN, BUKAN PRODUKSI!
        // mysqli_query($selectdb, "ALTER TABLE data_laptop AUTO_INCREMENT = 1"); 
        $_SESSION['pesan_sukses'] = "Data laptop berhasil dihapus!";
    } else {
        $_SESSION['pesan_error'] = "Anda tidak memiliki izin untuk menghapus data.";
    }
    header('Location: daftar_laptop.php'); // Redirect setelah operasi
    exit();
}

if(isset($_POST["tambah_laptop"])){
    if (isset($_SESSION['loggedin']) && $_SESSION['role'] === 'admin') {
        $nama      = $_POST["nama"];
        $harga     = $_POST["harga"];
        $processor = $_POST["processor"];
        $ram       = $_POST["ram"];
        $vga       = $_POST["vga"]; 
        $memori    = $_POST["memori"];
        $lcd       = $_POST["lcd"]; 

        // Mapping nilai ke angka (sesuai logika Anda)
        $harga_angka = 0;
        if($harga < 1000000){ $harga_angka = 5; } 
        elseif($harga >= 1000000 && $harga <= 3000000){ $harga_angka = 4; }
        elseif($harga > 3000000 && $harga <= 4000000){ $harga_angka = 3; }
        elseif($harga > 4000000 && $harga <= 5000000){ $harga_angka = 2; }
        elseif($harga > 5000000){ $harga_angka = 1; }

        $ram_angka = $ram; // Anda langsung menggunakan nilai RAM

        // $memori_angka = 0;
        // if($memori == 4){ $memori_angka = 1; }
        // elseif($memori == 8){ $memori_angka = 2; }
        // elseif($memori == 16){ $memori_angka = 3; }
        // elseif($memori == 32){ $memori_angka = 4; }
        // elseif($memori == 64){ $memori_angka = 5; }
        // elseif($memori == 128){ $memori_angka = 6; } 
        // elseif($memori == 256){ $memori_angka = 7; }
        // elseif($memori == 512){ $memori_angka = 8; }
        // elseif($memori == 1000){ $memori_angka = 9; }

        $processor_angka = 0;
        if($processor == "Dualcore"){ $processor_angka = 1; }
        elseif($processor == "Quadcore"){ $processor_angka = 3; }
        elseif($processor == "Octacore"){ $processor_angka = 5; }
        elseif($processor == "Intel Core i3" || $processor == "AMD Ryzen 3"){ $processor_angka = 2; }
        elseif($processor == "Intel Core i5" || $processor == "AMD Ryzen 5"){ $processor_angka = 4; }
        elseif($processor == "Intel Core i7" || $processor == "AMD Ryzen 7"){ $processor_angka = 6; }
        elseif($processor == "Intel Core i9" || $processor == "AMD Ryzen 9"){ $processor_angka = 7; }

        $vga_angka = 0;
        if($vga == "Integrated"){ $vga_angka = 1; }
        elseif($vga == "Dedicated Entry"){ $vga_angka = 3; }
        elseif($vga == "Dedicated Mid"){ $vga_angka = 4; }
        elseif($vga == "Dedicated High"){ $vga_angka = 5; }
        
        $lcd_angka = 0;
        if($lcd == 8){ $lcd_angka = 1; }
        elseif($lcd == 13){ $lcd_angka = 3; }
        elseif($lcd == 14){ $lcd_angka = 4; }
        elseif($lcd == 15){ $lcd_angka = 5; }
        elseif($lcd == 16){ $lcd_angka = 6; }
        elseif($lcd == 17){ $lcd_angka = 7; }

        // Kamera_angka untuk WP akan menggunakan nilai dari LCD yang diinput
        // Query INSERT
        // Pastikan urutan kolom sesuai dengan tabel data_laptop Anda
        $sql = "INSERT INTO `data_laptop` (`nama_laptop`, `harga_angka`, `ram_angka`, `memori_angka`, `processor_angka`, `vga_angka`, `lcd_angka`, `kamera_angka`, `harga_teks`, `ram_teks`, `memori_teks`, `processor_teks`, `vga_teks`, `lcd_teks`) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = mysqli_prepare($selectdb, $sql);
        
        mysqli_stmt_bind_param($stmt, "siiiiiisssssss", 
            $nama, 
            $harga, // Ini adalah harga mentah yang akan di-map di hasil.php
            $ram, 
            $memori, 
            $processor_angka, 
            $vga_angka, 
            $lcd_angka, 
            "Rp. " . number_format($harga, 0, ',', '.'), 
            $ram . " GB", 
            $memori . " GB", 
            $processor, 
            $vga, 
            $lcd . " Inch" 
        );

        if (mysqli_stmt_execute($stmt)) {
            $_SESSION['pesan_sukses'] = "Data laptop berhasil ditambahkan!";
        } else {
            $_SESSION['pesan_error'] = "Gagal menambah data: " . mysqli_error($selectdb);
        }
        mysqli_stmt_close($stmt);
    } else {
        $_SESSION['pesan_error'] = "Anda tidak memiliki izin untuk menambah data.";
    }
    header('Location: daftar_laptop.php'); 
    exit();
}
?>

<?php include('header.php'); // Asumsikan Anda memiliki file header.php ?>

<body>
    <div class="navbar-fixed">
        <nav>
            <div class="container">
                <div class="nav-wrapper">
                    <ul class="left" style="margin-left: -52px;">
                        <li><a href="index.php">HOME</a></li>

                        <li><a class="active" href="daftar_laptop.php">DAFTAR LAPTOP</a></li>
                        <?php
                        // Fungsi logout
                        if (isset($_GET['action']) && $_GET['action'] === 'logout') {
                            session_unset();
                            session_destroy();
                            header('Location: daftar_laptop.php');
                            exit();
                        }
                        ?>
                        <?php if (isset($_SESSION['loggedin'])): ?>
                        <?php if ($_SESSION['role'] === 'admin'): ?>
                        <li><a href="admin_dashboard.php">ADMIN</a></li>
                        <li><a href="login.php?action=logout">LOGOUT</a></li>
                        <?php else: // role === 'user' ?>
                        <li><a href="login.php?action=logout">LOGOUT</a></li>
                        <?php endif; ?>
                        <?php else: ?>
                        <li><a href="login.php">LOGIN</a></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </nav>
    </div>

    <div style="background-color: #efefef">
        <div class="container">
            <div class="section-card" style="padding: 40px 0px 20px 0px;">
                <ul>
                    <li>
                        <div class="row">
                            <div class="card">
                                <div class="card-content">
                                    <center>
                                        <h4 style="margin-bottom: 20px; margin-top: -8px;">DAFTAR LAPTOP</h4>
                                    </center>

                                    <?php if (isset($_SESSION['pesan_sukses'])): ?>
                                    <div class="card-panel green lighten-4 green-text text-darken-4">
                                        <?php echo $_SESSION['pesan_sukses']; unset($_SESSION['pesan_sukses']); ?>
                                    </div>
                                    <?php endif; ?>
                                    <?php if (isset($_SESSION['pesan_error'])): ?>
                                    <div class="card-panel red lighten-4 red-text text-darken-4">
                                        <?php echo $_SESSION['pesan_error']; unset($_SESSION['pesan_error']); ?>
                                    </div>
                                    <?php endif; ?>

                                    <?php if (isset($_SESSION['loggedin']) && $_SESSION['role'] === 'admin'): ?>
                                    <a href="#tambah" class="waves-effect waves-light btn teal"
                                        style="margin-bottom: 10px;">
                                        <i class="material-icons left">add</i>Tambah Laptop
                                    </a>
                                    <?php elseif (isset($_SESSION['loggedin']) && $_SESSION['role'] === 'user'): ?>
                                    <a href="#tambah" class="waves-effect waves-light btn teal disabled"
                                        style="margin-bottom: 10px;">
                                        <i class="material-icons left">add</i>Ajukan Laptop (Fitur Tambah Admin)
                                    </a>
                                    <?php endif; ?>

                                    <table id="table_id" class="hover dataTablesCustom" style="width:100%">
                                        <thead style="border-top: 1px solid #d0d0d0;">
                                            <tr>
                                                <th>
                                                    <center>No </center>
                                                </th>
                                                <th>
                                                    <center>Nama Laptop</center>
                                                </th>
                                                <th>
                                                    <center>Harga</center>
                                                </th>
                                                <th>
                                                    <center>Processor</center>
                                                </th>
                                                <th>
                                                    <center>RAM</center>
                                                </th>
                                                <th>
                                                    <center>Kartu Grafis</center>
                                                </th>
                                                <th>
                                                    <center>Memori</center>
                                                </th>
                                                <th>
                                                    <center>Ukuran LCD</center>
                                                </th>
                                                <?php if (isset($_SESSION['loggedin']) && $_SESSION['role'] === 'admin'): ?>
                                                <th>
                                                    <center>Aksi</center>
                                                </th>
                                                <?php endif; ?>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                                // Mengganti `data_hp` menjadi `data_laptop`
												$query=mysqli_query($selectdb,"SELECT * FROM data_laptop");
												$no=1;
												while ($data=mysqli_fetch_array($query)) {
												?>
                                            <tr>
                                                <td>
                                                    <center><?php echo $no++; ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data['nama_laptop'] ?></center>
                                                </td>
                                                <td>
                                                    <center>
                                                        <?php echo 'Rp. ', number_format($data['harga_angka'], 0, ',', '.'); ?>
                                                    </center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data['processor_angka'] ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data['ram_angka'],' GB' ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data['vga_angka'] ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data['memori_angka'], ' GB' ?></center>
                                                </td>
                                                <td>
                                                    <center><?php echo $data['lcd_angka'], ' inch' ?></center>
                                                </td>

                                                <?php if (isset($_SESSION['loggedin']) && $_SESSION['role'] === 'admin'): ?>
                                                <td>
                                                    <center>
                                                        <a href="edit_laptop.php?id=<?php echo $data['id_laptop'] ?>"
                                                            class="btn-floating btn-small waves-effect waves-light blue"
                                                            style="height: 32px; width: 32px;"><i
                                                                style="line-height: 32px;"
                                                                class="material-icons">edit</i></a>
                                                        <form method="POST" style="display:inline-block;">
                                                            <input type="hidden" name="id_hapus_laptop"
                                                                value="<?php echo $data['id_laptop'] ?>">
                                                            <button type="submit" name="hapus_laptop"
                                                                style="height: 32px; width: 32px;"
                                                                class="btn-floating btn-small waves-effect waves-light red"
                                                                onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?');"><i
                                                                    style="line-height: 32px;"
                                                                    class="material-icons">remove</i></button>
                                                        </form>
                                                    </center>
                                                </td>
                                                <?php endif; ?>
                                            </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <?php if (isset($_SESSION['loggedin']) && $_SESSION['role'] === 'admin'): ?>
    <div id="tambah" class="modal" style="width: 40%; height: auto;">
        <div class="modal-content">
            <div class="col s12">
                <div class="card-content">
                    <div class="row">
                        <center>
                            <h5 style="margin-top:-8px;">Masukan Laptop</h5>
                        </center>
                        <form method="POST" action="">
                            <div class="row">
                                <div class="col s12">

                                    <div class="input-field col s12">
                                        <input id="nama" name="nama" type="text" required>
                                        <label for="nama">Nama Laptop</label>
                                    </div>

                                    <div class="input-field col s12">
                                        <input id="harga" name="harga" type="number" required>
                                        <label for="harga">Harga</label>
                                    </div>

                                    <div class="input-field col s12">
                                        <select name="ram" required>
                                            <option value="" disabled selected>Pilih RAM</option>
                                            <option value="1">1 GB</option>
                                            <option value="2">2 GB</option>
                                            <option value="3">3 GB</option>
                                            <option value="4">4 GB</option>
                                            <option value="6">6 GB</option>
                                            <option value="8">8 GB</option>
                                            <option value="12">12 GB</option>
                                            <option value="16">16 GB</option>
                                            <option value="32">32 GB</option>
                                        </select>
                                        <label>RAM</label>
                                    </div>

                                    <div class="input-field col s12">
                                        <select name="memori" required>
                                            <option value="" disabled selected>Pilih Memori</option>
                                            <option value="4">4 GB</option>
                                            <option value="8">8 GB</option>
                                            <option value="16">16 GB</option>
                                            <option value="32">32 GB</option>
                                            <option value="64">64 GB</option>
                                            <option value="128">128 GB</option>
                                            <option value="256">256 GB</option>
                                            <option value="512">512 GB</option>
                                            <option value="1000">1 TB</option>
                                        </select>
                                        <label>Memori (Penyimpanan)</label>
                                    </div>

                                    <div class="input-field col s12">
                                        <select name="processor" required>
                                            <option value="" disabled selected>Pilih Processor</option>
                                            <option value="Dualcore">Dualcore</option>
                                            <option value="Quadcore">Quadcore</option>
                                            <option value="Octacore">Octacore</option>
                                            <option value="Intel Core i3">Intel Core i3</option>
                                            <option value="Intel Core i5">Intel Core i5</option>
                                            <option value="Intel Core i7">Intel Core i7</option>
                                            <option value="Intel Core i9">Intel Core i9</option>
                                            <option value="AMD Ryzen 3">AMD Ryzen 3</option>
                                            <option value="AMD Ryzen 5">AMD Ryzen 5</option>
                                            <option value="AMD Ryzen 7">AMD Ryzen 7</option>
                                            <option value="AMD Ryzen 9">AMD Ryzen 9</option>
                                        </select>
                                        <label>Processor</label>
                                    </div>

                                    <div class="input-field col s12">
                                        <select name="vga" required>
                                            <option value="" disabled selected>Pilih Kartu Grafis (VGA)</option>
                                            <option value="Integrated">Integrated (Intel UHD/Iris Xe, AMD Radeon)
                                            </option>
                                            <option value="Dedicated Entry">Dedicated Entry (GTX 1650, RTX 2050)
                                            </option>
                                            <option value="Dedicated Mid">Dedicated Mid (RTX 3050, RTX 4050)</option>
                                            <option value="Dedicated High">Dedicated High (RTX 3060+, RTX 4060+)
                                            </option>
                                        </select>
                                        <label>Kartu Grafis (VGA)</label>
                                    </div>

                                    <div class="input-field col s12">
                                        <select name="lcd" required>
                                            <option value="" disabled selected>Pilih Ukuran LCD</option>
                                            <option value="8">8 inci (misal untuk tablet)</option>
                                            <option value="13">13 inci</option>
                                            <option value="14">14 inci</option>
                                            <option value="15">15 inci</option>
                                            <option value="16">16 inci</option>
                                            <option value="17">17 inci</option>
                                        </select>
                                        <label>Ukuran LCD</label>
                                    </div>
                                </div>
                            </div>
                            <center><button name="tambah_laptop" type="submit" class="waves-effect waves-light btn teal"
                                    style="margin-top: 0px;">Tambah</button></center>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer" style="height: auto;">
            <a href="#!" class="modal-action modal-close waves-effect waves-green btn-flat">Tutup</a>
        </div>
    </div>
    <?php endif; // End if admin for modal ?>
    <?php include 'footer.php'; // Asumsikan Anda memiliki file footer.php ?>

    <script type="text/javascript">
    $(document).ready(function() {
        $('.modal').modal();
        $('select').formSelect(); // Inisialisasi select Materialize
        $('#table_id').DataTable({
            "paging": true,
            "ordering": true,
            "info": true
        });
    });
    </script>
</body>

</html>